
from .log import log
from . import db
from . import utils
from . import net
from . import file
from . import feishu

from .utils import jsonDump, jsonLoad, timeSleep

# 重写list的__str__方法
class _MyList(list):
    def __str__(self):
        return '\n'.join(str(item) for item in self)


# 实体类
class Entity:
    # 将对象转换为字符串
    def __str__(self):
        return jsonDump(self.__dict__)

    @classmethod
    def create(cls, data):
        if isinstance(data, dict):  
            return cls(data)
        elif isinstance(data, list):
            ret = [cls(item) for item in data]
            return _MyList(ret)
        else:
            raise ValueError('Invalid data type')
        