import sys
import argparse
sys.path.append(__file__.split('blue_script')[0] + 'blue_script')

from config import PROJECT
from lib.aws.alarm.db_slowlog import AuroraSlowLogManager

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='批量检查并设置 Aurora 集群的 slowlog')
    parser.add_argument('config_path', help='配置路径，例如: project_name/cloud_name/env_name')
    parser.add_argument('pattern', help='Aurora集群ID的正则表达式')
    args = parser.parse_args()

    try:
        PROJECT.readConfig(args.config_path)
        manager = AuroraSlowLogManager(PROJECT.aws)
        manager.check_and_create_slowlog_by_pattern(args.pattern)
    except Exception as e:
        print(f"Error: {str(e)}")
        sys.exit(1)