import boto3
import re
import argparse
import sys
sys.path.append(__file__.split('blue_script')[0] + 'blue_script')
from config import PROJECT
from lib.aws.alarm.db_alarm import DbAlarmManager

def parse_arguments():
    parser = argparse.ArgumentParser(description='创建Aurora无索引慢查询CloudWatch告警')
    parser.add_argument('config_path', help='配置路径')
    parser.add_argument('pattern', help='Aurora集群ID的正则表达式')
    parser.add_argument('threshold', type=int, help='无索引慢查询数量阈值')
    parser.add_argument('--alarm_topic', help='告警目标SNS Topic ARN。如果未指定，则从配置文件读取。')
    return parser.parse_args()

if __name__ == "__main__":
    try:
        args = parse_arguments()
        PROJECT.readConfig(args.config_path)
        alarm_topic = args.alarm_topic
        if not alarm_topic:
            alarm_topic = PROJECT.getConfig('alarm.sns_topic_arn')
        dbAlarmManager = DbAlarmManager(PROJECT.aws)
        dbAlarmManager.set_no_index_slow_queries_alarm_by_pattern(args.pattern, alarm_topic, args.threshold)
    except Exception as e:
        print(f"Error: {str(e)}")
        sys.exit(1)